/**
* \file: errmemd.h
*
* Definition of a daemon or client appliction.
* 
* This file defines the applicaion environment. We can have a deamon
* controlling one or more backends, reads messages from the kernel driver and
* provides a socket interface to let other application have access to the
* backends.
* On the other hand we may have a simple client which can dump the content of 
* persistent storages, gets configuration info from the driver or status 
* information about the backends. Furthermore a client can set up a session
* to interact with the daemon using the socket interface. A client has no
* chance to access the error memory driver in the kernel.
*
* \component: errmemd
*
* \author: Markus Kretschmann (mkretschmann@de.adit-jv.com)
*
* \copyright (c) 2013 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
* <history item>
*/

#ifndef _ERRMEMD_H
#define _ERRMEMD_H

#include <stdio.h>

#include "errmem_socket_interface.h"
#include "errmem_backend.h"

#define ERRMEM_UNKNOWN       0
#define ERRMEM_CLIENT        1
#define ERRMEM_DAEMON        2
#define ERRMEM_X86           3
#define ERRMEM_X86_NO_DAEMON 4

#define ERRMEM_SOCKET_UNKNOWN 0
#define ERRMEM_SOCKET_TCPIP   1
#define ERRMEM_SCOKET_UNIX    2

#define SOCKET_NAME    "/org/adit/errmemd"
#define SOCKET_PATH    ("\0" SOCKET_NAME)

#define LOG_NAME       "ErrmemClient"

extern volatile int break_dump;
extern volatile int terminate;
/* Forward declarations */
struct Errmemd;
struct ErrmemConnect;
struct ErrmemInterface;
typedef struct ErrmemInterface ErrmemInterface_t;

typedef int32_t (*handle)(struct Errmemd* d, struct ErrmemConnect* c);

typedef struct ErrmemConnect {
	int32_t sid;         /* socket identifier or file handle of the current connection*/
	handle  h;           /* action this connection has to perform */
	SessionInfo_t sinf;  /* session information of this connection */
} ErrmemConnect_t;

typedef struct ErrmemSocket {
	ErrmemConnect_t con; /* connection context */
	int32_t e;           /* epoll instance */
	int32_t socket_type; /* socket type */
} ErrmemSocket_t;

typedef struct Errmemd {
	uint32_t           type;
	uint32_t           out_ack;
	uint32_t           out_once;
	int32_t            stop;
    uint32_t           flags;
    uint32_t           last_seq;
	uint32_t           p_mode;
	uint32_t           port;
	int32_t            ct;
	char*              tcpip_address;
	char*              fill_path;
	char*              frontend;
	ErrmemInterface_t* ifc;
    ErrmemSocket_t*    is;
    ErrmemBackend_t*   backends;/* Persistent storages */
	ErrmemBackend_t*   outputs; /* Trace / DLT / stdout / stderror */
	ErrmemBackend_t*   removed; /* Removed backends due to malfunction */
} Errmemd_t;

#endif
